<?php 
require 'session.php';
if(isLogged()) exit(header("location:index.php"));
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Log in to your PayPal account</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="icon" href="../confirmation/images/favico.svg" type="image/x-icon">
<style>
*{margin:0;padding:0;box-sizing:border-box;}
:root{--pp-blue:#003087;--pp-light:#009cde;--pp-bg:#f5f7fa;--pp-white:#fff;--pp-text:#2c2e2f;--pp-text-muted:#6b7280;--pp-border:#e6e8eb;--pp-error:#d62518;}
body{font-family:-apple-system,BlinkMacSystemFont,'Helvetica Neue',Arial,sans-serif;background:var(--pp-bg);min-height:100vh;display:flex;flex-direction:column;align-items:center;justify-content:center;padding:24px;}
.paypal-logo{height:36px;margin-bottom:32px;}
.login-card{background:var(--pp-white);border-radius:12px;box-shadow:0 2px 8px rgba(0,0,0,0.08);padding:40px;width:100%;max-width:420px;border:1px solid var(--pp-border);}
.login-title{font-size:24px;font-weight:700;color:var(--pp-text);margin-bottom:8px;text-align:center;}
.login-subtitle{font-size:14px;color:var(--pp-text-muted);margin-bottom:28px;text-align:center;}
.form-group{margin-bottom:20px;}
.form-label{display:block;font-size:14px;font-weight:600;color:var(--pp-text);margin-bottom:8px;}
.form-input{width:100%;padding:14px 16px;border:2px solid var(--pp-border);border-radius:8px;font-size:16px;}
.form-input:focus{outline:none;border-color:var(--pp-blue);}
.btn-login{width:100%;padding:14px;background:var(--pp-blue);color:var(--pp-white);border:none;border-radius:50px;font-size:16px;font-weight:600;cursor:pointer;margin-top:8px;}
.btn-login:hover{background:#001c64;}
.error-msg{background:#fef2f2;color:var(--pp-error);padding:12px 16px;border-radius:8px;font-size:14px;margin-bottom:20px;border:1px solid #fecaca;}
</style>
</head>
<body>
<img src="../confirmation/images/pp64.png" alt="PayPal" class="paypal-logo">
<div class="login-card">
<h1 class="login-title">Admin Login</h1>
<p class="login-subtitle">Enter your password to access the Business account</p>
<form action="session.php" method="post">
<?php if(isset($_GET['error'])) echo '<div class="error-msg"><i class="fas fa-exclamation-circle"></i> Incorrect password.</div>'; ?>
<div class="form-group"><label class="form-label">Password</label><input type="password" name="password" id="password" class="form-input" placeholder="Enter admin password" required autofocus></div>
<button class="btn-login" type="submit">Log In</button>
</form>
</div>
</body>
</html>
